# Contextualized Question Generation

## Definition
- Contextualized question generation is a method of designing questions. Its core feature is to integrate the knowledge points and ability requirements to be tested into a real and vivid situation, aiming to stimulate students' interest in learning and examine their ability to apply and transfer knowledge.

## Evaluation Framework
- Task Setting:
  - Provide the model with clear prompts, including specified knowledge points, core competencies to be examined, question difficulty, and specific format requirements.
  - The model needs to create a suitable context and generate a set of questions that meet the requirements within a single round of dialogue.
- Evaluation Data Collection:
  - The questions generated by the model will serve as the complete data for evaluation.
## Evaluation Metrics
- The evaluation metrics include five first-level indicators: Quality of Question Content, Quality of Answer and Explanation, Quality of Question Context, Teaching Assistance, and Embodiment of Values.
  - Each first-level indicator includes: a description of the indicator, positive examples, and negative examples.

<table border="1">
  <tr>
    <td>Evaluation Metric</td>
    <td rowspan="2" colspan="1">Description</td>
    <td rowspan="2" colspan="1">Positive Example</td>
    <td rowspan="2" colspan="1">Negative Example</td>
  </tr>
  <tr>
    <td>First-level Metric</td>
  </tr>
  <tr>
    <td>Quality of Question Content</td>
    <td>① The question is clear and easy to understand, without ambiguous or misleading statements.
② The question is solvable, and the correct solution can be enumerated. For multiple-choice questions, it should lead to a single answer.
③ The question effectively tests the specified knowledge points and is consistent with the curriculum standards.
④ The question effectively tests the core competencies mentioned by the teacher.
⑤ The difficulty of the question is basically consistent with the difficulty specified by the teacher.</td>
    <td>Convert 65/9 to a mixed number ().

A. 7 and 5/9
B. 7 and 2/9
C. 6 and 5/9
D. 6 and 2/9
【Reference Answer】B
【Analysis】Because 7×9=63,
So 65/9 = 7 and 2/9, so the answer is B.</td>
    <td>A question with infinitely many solutions: Given set A={2,3}, and set B satisfies A∩B={2}, how many such sets B are there?
A question where the knowledge point being tested is inconsistent with the requirement, e.g., using this question to test rounding: Xiaoming has 17.45 yuan, and he wants to buy a notebook that costs 17.5 yuan. Can he afford it?</td>
  </tr>
  <tr>
    <td>Quality of Answer and Explanation</td>
    <td>① The answer to the question is accurate and covers all possible correct answers.
② The explanation covers the mainstream problem-solving approaches, is closely related to the current knowledge point, and does not involve out-of-syllabus knowledge.
③ The explanation is logical, coherent, and clear, without obvious jumps in steps or thinking.</td>
    <td>
Form a sentence by arranging the words and adding punctuation. (Fill in the serial numbers)
①This is ②a ③! (particle)
④lovely ⑤bird ⑥what a
Answer: ①⑥④②⑤③！
Analysis: First, observe these words. "This is" is the beginning of the sentence, "a" is used to limit the quantity, "lovely" modifies "bird", "what a" enhances the tone, and "呀" is an interjection. The whole sentence expresses admiration for the bird and is an exclamatory sentence, so an exclamation mark is used at the end. Thus, it forms "What a lovely bird this is!". So the order is: ①⑥④②⑤③!</td>
    <td>Form a sentence by arranging the words and adding punctuation.
on the grass, a rabbit, is, eating grass, happily
Answer:
The rabbit is happily eating grass on the grass.
Analysis:
This question mainly tests the ability of second-grade students to correctly arrange the order of words. They need to master the basic sentence structure of "subject + adverbial of place + modifier + predicate".
1. The subject "rabbit" should be placed at the beginning of the sentence.
2. The adverbial of place "on the grass" should follow the subject.
3. The modifier "happily" should be placed before the verb "eating grass".
4. Note that the verb phrase "eating grass" cannot be split.
5. A period should be added at the end of the sentence.</td>
  </tr>
  <tr>
    <td>Quality of Question Context</td>
    <td>① The context is derived from real life and is in line with the students' current cognitive level.
② The context background and the knowledge tested in the question form an integrated whole, rather than being independent of each other.
③ The context is clearly and normatively described, with a simple structure.
④ The story in the context conforms to Chinese socialist values and is based on "cultivating virtue through education".</td>
    <td>Xiaoming bought a bottle of milk at the supermarket for 5 yuan. He paid the cashier with a 10 yuan bill. How much change will Xiaoming receive?
Solution:
First, we need to calculate the difference between the money Xiaoming paid and the price of the item.
Item price: 5 yuan
Payment amount: 10 yuan
Difference = Payment amount - Item price
Difference = 10 yuan - 5 yuan
Difference = 5 yuan
Therefore, Xiaoming will receive 5 yuan in change.</td>
    <td>When the context and knowledge are independent and not integrated:
At the school science fair, Xiaohua and her friends decided to display a large cube model made of small cubic sugar cubes. If the volume of the large cube model is 729 cubic centimeters and the volume of each small cubic sugar cube is 1 cubic centimeter, what is the side length of the large cube in centimeters?
When the context of the question does not conform to the "cultivating virtue through education" principle and may mislead children's values: for example, Xiaoming ate 40 candies today, or using drinking alcohol as a context.
Or when the context of the question is unrealistic: Xiaoming's grandfather's speed is 100m/s.</td>
  </tr>
  <tr>
    <td>Teaching Assistance</td>
    <td>The dialogue should have good teaching applicability and be able to assist teachers in achieving teaching goals. For example, whether the provided content can stimulate students' thinking and discussion, whether it is convenient for teachers to conduct guided explanations or expansions in the classroom, and whether it can lead to multiple solutions or multi-angle analysis. The questions and explanations should support teachers in common teaching links such as concept clarification, knowledge transfer, and error analysis, and have strong potential as teaching aids.</td>
    <td>"The question design can guide students to propose different solutions, such as 'Can you solve it in another way?'"
"Can be used as a review or extension question, such as 'Please solve this equation in two ways.'"
"Suitable for classroom interaction, such as 'predict the result' or 'group debate'."</td>
    <td>"The question is mechanical and repetitive, and cannot be used for teaching discussion."
"It can only be solved by directly applying a formula and cannot stimulate thinking."
"The design cannot lead to opportunities for knowledge transfer or concept clarification."</td>
  </tr>
  <tr>
    <td>Embodiment of Values</td>
    <td>The dialogue should reflect socialist core values and advocate positive concepts such as integrity, environmental protection, diligence, friendliness, and law-abidingness. The context design should avoid negative content such as violence, gambling, alcoholism, addictive behaviors, gender stereotypes, and consumerism. If the question does not reflect value guidance but has no obvious problems, it can be rated neutrally; if there is clear positive guidance, it should be given a high score. As educational content, questions should have a basic educational orientation and social responsibility. Note that when evaluating this dimension, you do not need to evaluate the quality of the question stem, context, explanation, and other parts of the dialogue; you only need to focus on the values.</td>
    <td>"Using volunteer service, saving water, and labor practice as the background of the questions to encourage students to think independently and help others, and using integrity, environmental protection, and patriotism as the themes for value guidance."</td>
    <td>"Settings that encourage violence, fighting, comparison, addictive behaviors (such as opening blind boxes, indulging in online games), imply gender discrimination or prejudice, such as 'girls are not good at calculation', or contexts that guide consumerism, such as 'buy 50 limited edition toys'."</td>
  </tr>
</table>

## Evaluation Cases
- By combining 10 different knowledge points, competencies, grades, and difficulty levels, the model was asked to generate questions. Then, based on the user's requirements and the generated questions, 10 cases were constructed to evaluate the model's question generation ability.

<table border="1">
  <tr>
    <td>Knowledge Point</td>
    <td>Competency</td>
    <td>Grade</td>
    <td>Difficulty</td>
  </tr>
  <tr>
    <td>Rounding</td>
    <td>Number Sense</td>
    <td>Grade 5, First Semester</td>
    <td>Easy</td>
  </tr>
  <tr>
    <td>Comparing Fractions</td>
    <td>Computational Skills
Data Awareness</td>
    <td>Grade 5, Second Semester</td>
    <td>Hard</td>
  </tr>
  <tr>
    <td>Linear Equations in One Variable - Review Summary</td>
    <td>Computational Skills
Reasoning Ability
Application Awareness</td>
    <td>Grade 7, First Semester</td>
    <td>Hard</td>
  </tr>
  <tr>
    <td>Determining Position with Ordered Pairs</td>
    <td>Spatial Conception</td>
    <td>Grade 5, First Semester</td>
    <td>Easy</td>
  </tr>
  <tr>
    <td>Reducing Fractions and Simplest Fractions</td>
    <td>Computational Skills</td>
    <td>Grade 8, First Semester</td>
    <td>Medium</td>
  </tr>
  <tr>
    <td>Hectares and Square Kilometers</td>
    <td>Sense of Measurement
Application Awareness</td>
    <td>Grade 4, First Semester</td>
    <td>Medium</td>
  </tr>
</table> 